/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8260.DeviceView;

import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8260.DeviceView.DefaultStatus;
import ibm.nways.jdm8260.DeviceView.HubInfoLike;
import ibm.nways.jdm8260.DeviceView.LeafCompositeLike;
import ibm.nways.jdm8260.DeviceView.ModuleLike;
import ibm.nways.jdm8260.MibValue;
import ibm.nways.jdm8260.model.QuickAgentsModel;
import ibm.nways.ras.RAS;
import java.awt.Point;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Module
implements ModuleLike {
    protected int numberOfPorts;
    protected int numberOfBridgePorts;
    protected int numberOfSlots;
    protected String backgroundGif = "";
    protected int growthDirection;
    protected int modType;
    protected Point location;
    protected int slot;
    protected int subSlot;
    protected GraphicContainer graphicContainer;
    protected GraphicContainer moduleContainer = new GraphicContainer();
    private Vector components = new Vector();
    protected String destinationPanel;
    protected boolean hasPorts = false;
    protected boolean hasMauPorts = false;
    protected boolean hasTrunks = false;
    protected HubInfoLike hub;
    protected int network;
    protected boolean is8250Flag = false;
    protected static final String BUNDLE_NAME = "ibm.nways.jdm8260.DeviceView.GraphicResources";
    protected static final String SER_PATH = "ibm.nways.jdm8260.WCDefault";
    protected static final int COOKIE_FLAGS = 28;
    protected static final int COOKIE_FLAGS_FLYOVER = 20;
    protected int iconType;
    protected String description = "";
    protected String cookieID;
    protected GenModel modModel;
    protected GenModel portsModel;
    protected GenModel trunksModel;
    protected GenModel mauPortsModel;
    private String cachedIPAddress;
    protected boolean _8250_module_on_8260 = false;
    public static final int MME = 0;
    public static final int MCOC = 1;
    public static final int MAGE = 3;
    public static final int MMEE = 4;
    public static final int MMET = 5;
    public static final int MMEV = 6;
    public static final int MMEB = 7;
    public static final int MAGF = 9;
    public static final int MMEF = 10;
    public static final int MAGT = 12;
    public static final int MAG = 13;
    public static final int MMED = 15;
    public static final int MMERMON = 16;
    public static final int MMEA = 17;
    public static final int MMELIGHT = 18;
    public static final int MMES = 19;
    public static final int MMEAS = 20;
    public static final int MME_BRGA = 23;
    public static final int MMER = 24;
    public static final int MME_MSS = 25;
    public static final int MME_VDM = 26;
    public static String[] modStatusGifs = new String[]{"mme.gif", "mcoc.gif", "mmae.gif", "mage.gif", "mmee.gif", "mmet.gif", "mmev.gif", "mmeb.gif", "mmaf.gif", "magf.gif", "mmef.gif", "mmat.gif", "magt.gif", "mag.gif", "mma.gif", "mmed.gif", "mmermon.gif", "mmea.gif", "mmelight.gif", "mmes.gif", "mmeas.gif", "mmeas_back.gif", "mme_tv.gif", "mme_brga.gif", "mmer.gif", "mme_mss.gif", "mme_vdm.gif"};

    public void dispose() {
        this.modModel = null;
        this.portsModel = null;
        this.trunksModel = null;
        this.mauPortsModel = null;
        this.graphicContainer = null;
        if (this.moduleContainer != null) {
            this.moduleContainer.dispose();
            this.moduleContainer = null;
        }
        this.hub = null;
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            ((LeafCompositeLike)enumeration.nextElement()).dispose();
        }
        this.components.removeAllElements();
    }

    public void draw() {
        String string = "draw";
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            LeafCompositeLike leafCompositeLike = (LeafCompositeLike)enumeration.nextElement();
            try {
                leafCompositeLike.draw();
            }
            catch (Exception exception) {
                if (RAS.isEnabled(19, 2)) {
                    RAS.trace(19, 2, this, string, "Exception drawing object -> " + leafCompositeLike.getClass().getName());
                }
                RAS.logException(19, 2, this, string, exception);
            }
        }
        this.graphicContainer.add(this.moduleContainer);
    }

    public final void add(LeafCompositeLike leafCompositeLike) {
        if (leafCompositeLike != null) {
            this.components.addElement(leafCompositeLike);
        }
    }

    public GenModel getModel() {
        return this.modModel;
    }

    public ModelInfo getModelInfo() {
        ModelInfo modelInfo = new ModelInfo();
        modelInfo.add("Index.ModSlotIndex", new Integer(this.slot));
        modelInfo.add("Index.ModSubSlotIndex", new Integer(this.subSlot));
        return modelInfo;
    }

    public String getDestinationPanel() {
        return this.destinationPanel;
    }

    public final void setCommonInformation(HubInfoLike hubInfoLike, int n, int n2, GraphicContainer graphicContainer, int n3, int n4, int n5, int n6, int n7, GenModel genModel) {
        String string = "setCommonInformation";
        this.hub = hubInfoLike;
        this.slot = n;
        this.subSlot = n2;
        this.graphicContainer = graphicContainer;
        this.numberOfPorts = n3;
        this.numberOfBridgePorts = n4;
        this.numberOfSlots = n5;
        this.network = n6;
        if (n7 > 0) {
            this.growthDirection = n7 - 1;
        }
        Serializable serializable = this.hub.getMibInfo().getVar("ocModBogus", "." + this.slot + "." + this.subSlot);
        try {
            this.modModel = (GenModel)genModel.getComponent("ModData");
        }
        catch (Exception exception) {
            RAS.logException(19, 2, this, string, exception);
        }
        if (this.hasPorts) {
            try {
                this.portsModel = (GenModel)genModel.getComponent("Ports");
            }
            catch (Exception exception) {
                RAS.logException(19, 2, this, string, exception);
            }
        }
        if (this.hasTrunks) {
            try {
                this.trunksModel = (GenModel)genModel.getComponent("Trunks");
            }
            catch (Exception exception) {
                RAS.logException(19, 2, this, string, exception);
            }
        }
        if (this.hasMauPorts) {
            try {
                this.mauPortsModel = (GenModel)genModel.getComponent("MauPorts");
            }
            catch (Exception exception) {
                RAS.logException(19, 2, this, string, exception);
            }
        }
        if (serializable instanceof MibValue) {
            this._8250_module_on_8260 = true;
        }
    }

    public final void addModuleStatusIcon(Point point) {
        String string = "gif/icon_";
        try {
            string = String.valueOf(string) + modStatusGifs[this.iconType];
        }
        catch (Exception exception) {
            string = String.valueOf(string) + modStatusGifs[0];
        }
        GraphicImage graphicImage = new GraphicImage(this.hub.getBrowser().imageFrom((Object)this, string), point, 3, null, null);
        if (this.modModel != null) {
            this.hub.askStatus(this.modModel, graphicImage, null, this);
        }
        graphicImage.setStatus(DefaultStatus.getDefaultStatus());
        this.graphicContainer.add((GraphicComponent)graphicImage);
    }

    public void setSpecificInformation() {
    }

    public void discoverChildren() {
    }

    public boolean is8250Module() {
        return this.is8250Flag;
    }

    public String getIPAddress() {
        if (this.cachedIPAddress == null) {
            Serializable serializable = this.hub.getMibInfo().getVectorVar("agentsIPAddress", "." + this.slot, QuickAgentsModel.Index.ids);
            this.cachedIPAddress = serializable instanceof IPAddress ? serializable.toString() : "0.0.0.0";
        }
        return this.cachedIPAddress;
    }

    public final int getGrowthDirection() {
        return this.growthDirection;
    }

    public final void setLocation(Point point) {
        this.location = point;
        this.moduleContainer.setLocation(this.location.x, this.location.y);
    }
}

